/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.feature.gen;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2794;
import net.minecraft.class_3031;
import net.minecraft.class_5281;
import net.minecraft.class_5821;
import net.minecraft.class_6796;
import net.minecraft.class_6880;
import potionstudios.byg.common.world.feature.config.NoisySphereConfig;
import potionstudios.byg.common.world.feature.config.RadiusMatcher;
import potionstudios.byg.common.world.math.noise.fastnoise.FastNoise;

public class NoiseSphere
extends class_3031<NoisySphereConfig> {
    protected static FastNoise fastNoise;
    protected long seed;

    public NoiseSphere(Codec<NoisySphereConfig> configCodec) {
        super(configCodec);
    }

    public boolean method_13151(class_5821<NoisySphereConfig> featurePlaceContext) {
        return this.place(featurePlaceContext.method_33652(), featurePlaceContext.method_33653(), featurePlaceContext.method_33654(), featurePlaceContext.method_33655(), (NoisySphereConfig)featurePlaceContext.method_33656());
    }

    public boolean place(class_5281 world, class_2794 chunkGenerator, Random random, class_2338 position, NoisySphereConfig config) {
        this.setSeed(world.method_8412(), config.noiseFrequency());
        boolean use2D = random.nextDouble() < config.noise2DChance();
        RadiusMatcher radiusMatcher = config.radiusMatcher();
        class_2338.class_2339 mutable = new class_2338.class_2339().method_10101((class_2382)position);
        class_2338.class_2339 mutable2 = new class_2338.class_2339().method_10101((class_2382)mutable);
        NoisySphereConfig.RadiusSettings radiusSettings = config.radiusSettings();
        int xRadius = radiusSettings.xRadius().method_35008(random) / 2;
        int yRadius = radiusMatcher == RadiusMatcher.ALL ? xRadius : radiusSettings.yRadius().method_35008(random);
        int zRadius = radiusMatcher == RadiusMatcher.ALL || radiusMatcher == RadiusMatcher.XZ ? xRadius : radiusSettings.zRadius().method_35008(random) / 2;
        int lowestX = position.method_10263();
        int lowestY = position.method_10264();
        int lowestZ = position.method_10260();
        int stackHeight = config.stackHeight().method_35008(random);
        for (int stackIDX = 0; stackIDX < stackHeight; ++stackIDX) {
            for (int x = -xRadius; x <= xRadius; ++x) {
                float xFract = (float)x / (float)xRadius;
                for (int z = -zRadius; z <= zRadius; ++z) {
                    float zFract = (float)z / (float)zRadius;
                    for (int y = -yRadius; y <= yRadius + radiusSettings.upperHalfAdditional(); ++y) {
                        float yFract = (float)y / (float)yRadius;
                        mutable2.method_10101((class_2382)mutable).method_10100(x, y, z);
                        float distanceSquaredFromCenter = xFract * xFract + yFract * yFract + zFract * zFract;
                        float yDistSquared = yFract * yFract;
                        float noise = use2D ? fastNoise.GetNoise(mutable2.method_10263(), mutable2.method_10260()) : fastNoise.GetNoise(mutable2.method_10263(), mutable2.method_10264(), mutable2.method_10260());
                        float threshold = 1.0f + 0.7f * noise;
                        float factor = yDistSquared / threshold;
                        if (factor >= 1.0f) {
                            distanceSquaredFromCenter /= factor;
                            distanceSquaredFromCenter = (float)((double)distanceSquaredFromCenter - Math.copySign((double)noise * 0.2, (double)distanceSquaredFromCenter));
                        }
                        if (distanceSquaredFromCenter >= threshold) continue;
                        int squaredDistance = x * x + y * y + z * z;
                        if (config.checkSquareDistance() && squaredDistance >= xRadius * zRadius) continue;
                        world.method_8652((class_2338)mutable2, config.topBlockProvider().method_23455(random, (class_2338)mutable2), 2);
                        world.method_8652((class_2338)mutable2.method_10098(class_2350.field_11033), config.blockProvider().method_23455(random, (class_2338)mutable2), 2);
                        lowestX = Math.min(lowestX, mutable2.method_10263());
                        lowestY = Math.min(lowestY, mutable2.method_10264());
                        lowestZ = Math.min(lowestZ, mutable2.method_10260());
                    }
                }
            }
            xRadius = (int)((double)xRadius / config.radiusDivisorPerStack());
            yRadius = (int)((float)yRadius * 0.1f);
            mutable.method_33098(mutable.method_10264() + yRadius);
            zRadius = (int)((double)zRadius / config.radiusDivisorPerStack());
        }
        for (class_6880 spawningFeature : config.spawningFeatures()) {
            ((class_6796)spawningFeature.comp_349()).method_39644(world, chunkGenerator, random, new class_2338(lowestX, lowestY, lowestZ));
        }
        return true;
    }

    public void setSeed(long seed, float noiseFreq) {
        if (this.seed != seed || fastNoise == null) {
            fastNoise = new FastNoise((int)seed);
            fastNoise.SetNoiseType(FastNoise.NoiseType.Cellular);
            this.seed = seed;
        }
        fastNoise.SetFrequency(noiseFreq);
    }
}

